<?php
header('Content-Type: application/json');

include './headers.php';
include './connection.php';

$sql = "SELECT * FROM templates ORDER BY id DESC";
$res = mysqli_query($connection, $sql);

if (!$res) {
    echo json_encode(["error" => mysqli_error($connection)]);
    exit;
}

$data = [];
while ($row = mysqli_fetch_assoc($res)) {
    // Convert all values to UTF-8 to prevent json_encode from breaking
    array_walk_recursive($row, function (&$value) {
        if (!mb_detect_encoding($value, 'UTF-8', true)) {
            $value = utf8_encode($value);
        }
    });
    $data[] = $row;
}

echo json_encode($data);
mysqli_close($connection);
